/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import main.DataContainer;
import main.DrawingPanel;
import main.LoginForm;

public class MainForm
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = -152870869690218877L;
    private LoginForm logForm;
    private JScrollPane scrollPane;
    private JEditorPane editField;
    private DrawingPanel drawPanel;
    private JTextField textField;
    private StringBuilder displayText = new StringBuilder();
    private DataContainer playerData = new DataContainer();
    private Timer timer;

    public MainForm(String title) {
        super(title);
        this.initForm();
    }

    private void initForm() {
        this.setSize(500, 300);
        this.setLocation(300, 300);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout(5, 5));
        this.drawPanel = new DrawingPanel(this.playerData);
        this.add((Component)this.drawPanel, "Center");
        this.editField = new JEditorPane("text/html;charset=utf8", "");
        this.editField.setEditable(false);
        this.editField.setContentType("text/html;charset=utf8");
        this.scrollPane = new JScrollPane(this.editField, 22, 31);
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        this.add((Component)this.scrollPane, "After");
        this.textField = new JTextField();
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainForm.this.sendChatMessage();
                }
            }
        });
        this.add((Component)this.textField, "Last");
        this.playerData.setChatDisplay(this);
        this.drawPanel.addMouseListener(this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.playerData, 1000L, 10L);
        Thread panelUpdate = new Thread(this.drawPanel);
        panelUpdate.start();
        this.setVisible(true);
        this.repaint();
        this.logForm = new LoginForm();
        this.logForm.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (((MainForm)MainForm.this).logForm.submitted.booleanValue()) {
                    MainForm.this.playerData.loginPlayer(((MainForm)MainForm.this).logForm.userName, ((MainForm)MainForm.this).logForm.userPwd);
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainForm.this.timer.cancel();
                if (((MainForm)MainForm.this).playerData.isLoggedIn.booleanValue()) {
                    MainForm.this.playerData.logoutPlayer();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.logForm.showForm(this.getLocationOnScreen().x + this.getWidth() / 2 - this.logForm.getWidth(), this.getLocationOnScreen().y + this.getHeight() / 2 - this.logForm.getHeight());
    }

    private void sendChatMessage() {
        String chatParameter = "";
        try {
            chatParameter = "messages[sender]=" + URLEncoder.encode(String.valueOf(this.playerData.currentUser.id), "UTF-8") + "&messages[position]=" + URLEncoder.encode(String.valueOf(this.playerData.currentUser.room), "UTF-8") + "&messages[message]=" + URLEncoder.encode(this.textField.getText(), "UTF-8") + "&messages[tstamp]=1";
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        this.playerData.serverConnection.sendData("setdata.php", chatParameter);
        this.textField.setText("");
    }

    public void writeText(String text) {
        this.displayText.append(String.valueOf(this.wrapText(text)) + "<br>");
        this.editField.setText(this.displayText.toString());
        this.editField.setCaretPosition(this.editField.getDocument().getLength());
        this.repaint();
    }

    private String wrapText(String text) {
        int wrapWidth = 40;
        text = text.replace("\r\n", "\r").replace("\n", "<br>").replace("\r", "<br>");
        int lookupIndex = 0;
        while (lookupIndex + wrapWidth < text.length()) {
            int nextBreak = text.indexOf("<br>", lookupIndex);
            if (nextBreak < 1 || nextBreak > lookupIndex + wrapWidth) {
                int newBreakPos = text.lastIndexOf(" ", lookupIndex + wrapWidth);
                if (newBreakPos < lookupIndex) {
                    newBreakPos = text.lastIndexOf(",", lookupIndex + wrapWidth);
                }
                if (newBreakPos < lookupIndex) {
                    newBreakPos = text.lastIndexOf(".", lookupIndex + wrapWidth);
                }
                if (newBreakPos < lookupIndex) {
                    newBreakPos = lookupIndex + wrapWidth;
                }
                text = String.valueOf(text.substring(0, newBreakPos)) + "<br>" + text.substring(newBreakPos);
                lookupIndex = newBreakPos + 5;
                continue;
            }
            lookupIndex = nextBreak;
        }
        return text;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.playerData.isLoggedIn.booleanValue()) {
            if (!this.logForm.isVisible()) {
                this.logForm.showForm(this.getLocationOnScreen().x + this.getWidth() / 2 - this.logForm.getWidth(), this.getLocationOnScreen().y + this.getHeight() / 2 - this.logForm.getHeight());
            }
        } else {
            float relFactor = 800.0f / (float)(this.drawPanel.getWidth() > this.drawPanel.getHeight() ? this.drawPanel.getHeight() : this.drawPanel.getWidth());
            Point walkToPoint = new Point();
            walkToPoint.x = (int)((float)e.getPoint().x * relFactor - 25.0f);
            walkToPoint.y = (int)((float)e.getPoint().y * relFactor - 50.0f);
            if (walkToPoint.x > 750) {
                walkToPoint.x = 750;
            }
            if (walkToPoint.y > 700) {
                walkToPoint.y = 700;
            }
            this.playerData.userTargetPoint = walkToPoint;
            this.playerData.userSpeed = (int)Math.sqrt(this.drawPanel.getWidth());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

