/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader {
    private String inputString;
    private int braceCount = 0;
    private StringBuilder currentField = null;
    private boolean isReadingField = false;
    private StringBuilder currentValue = null;
    private boolean isReadingValue = false;
    private boolean colonRead = false;
    private boolean escapeOn = false;
    private Hashtable<String, String> resultHash = null;

    public JSONReader() {
    }

    public JSONReader(String inputJSON) {
        this.inputString = inputJSON.trim();
    }

    public void setInputString(String inputString) {
        this.inputString = inputString.trim();
        this.resultHash = null;
    }

    public String getInputString() {
        return this.inputString;
    }

    public Hashtable<String, String> readInput() {
        if (this.resultHash != null) {
            return this.resultHash;
        }
        this.resultHash = new Hashtable();
        if (this.inputString.length() > 1) {
            if (this.inputString.charAt(0) == '{') {
                return this.readJsonObject();
            }
            if (this.inputString.charAt(0) == '[') {
                return this.readJsonArray();
            }
            return this.resultHash;
        }
        return this.resultHash;
    }

    private Hashtable<String, String> readJsonObject() {
        this.inputString = this.inputString.substring(1, this.inputString.length() - 1).trim();
        this.isReadingField = false;
        this.isReadingValue = false;
        this.colonRead = false;
        this.escapeOn = false;
        int i = 0;
        while (i < this.inputString.length()) {
            switch (this.inputString.charAt(i)) {
                case '{': {
                    ++this.braceCount;
                    if (this.colonRead && !this.isReadingValue) {
                        this.isReadingValue = true;
                        this.currentValue = new StringBuilder("{");
                        break;
                    }
                    if (!this.isReadingValue) break;
                    this.currentValue.append("{");
                    break;
                }
                case '}': {
                    --this.braceCount;
                    this.currentValue.append("}");
                    if (this.braceCount != 0 || !this.isReadingValue) break;
                    this.isReadingValue = false;
                    this.resultHash.put(this.currentField.toString(), this.currentValue.toString());
                    break;
                }
                case '[': {
                    ++this.braceCount;
                    if (!this.isReadingValue) {
                        this.isReadingValue = true;
                        this.colonRead = true;
                        this.currentValue = new StringBuilder("[");
                        break;
                    }
                    this.currentField.append("[");
                    break;
                }
                case ']': {
                    --this.braceCount;
                    this.currentValue.append("]");
                    if (this.braceCount != 0 || !this.isReadingValue) break;
                    this.isReadingValue = false;
                    this.resultHash.put(this.currentField.toString(), this.currentValue.toString());
                    break;
                }
                case '\"': {
                    if (this.isReadingField) {
                        if (this.escapeOn) {
                            this.currentField.append('\"');
                        } else {
                            this.isReadingField = false;
                        }
                    } else if (this.isReadingValue) {
                        if (this.escapeOn) {
                            this.currentValue.append('\"');
                        } else if (this.braceCount == 0) {
                            this.isReadingValue = false;
                            this.resultHash.put(this.currentField.toString(), this.currentValue.toString());
                        } else {
                            this.currentValue.append('\"');
                        }
                    } else if (this.colonRead) {
                        this.isReadingValue = true;
                        this.currentValue = new StringBuilder();
                    } else {
                        this.isReadingField = true;
                        this.currentField = new StringBuilder();
                    }
                    this.escapeOn = false;
                    break;
                }
                case ':': {
                    if (this.isReadingValue) {
                        this.currentValue.append(':');
                        break;
                    }
                    this.colonRead = true;
                    break;
                }
                case ',': {
                    if (!this.isReadingField && !this.isReadingValue) {
                        this.colonRead = false;
                        break;
                    }
                    if (this.isReadingField) {
                        this.currentField.append(",");
                        break;
                    }
                    if (!this.isReadingValue) break;
                    this.currentValue.append(",");
                    break;
                }
                case '\\': {
                    this.escapeOn = !this.escapeOn;
                    break;
                }
                default: {
                    this.escapeOn = false;
                    if (this.isReadingField) {
                        this.currentField.append(this.inputString.charAt(i));
                        break;
                    }
                    if (!this.isReadingValue) break;
                    this.currentValue.append(this.inputString.charAt(i));
                }
            }
            ++i;
        }
        return this.resultHash;
    }

    private Hashtable<String, String> readJsonArray() {
        int fieldCounter = 0;
        this.inputString = this.inputString.substring(1, this.inputString.length() - 1).trim();
        int i = 0;
        while (i < this.inputString.length()) {
            switch (this.inputString.charAt(i)) {
                case '{': {
                    ++this.braceCount;
                    if (!this.isReadingValue) {
                        this.isReadingValue = true;
                        this.currentValue = new StringBuilder("{");
                        break;
                    }
                    this.currentValue.append("{");
                    break;
                }
                case '}': {
                    --this.braceCount;
                    this.currentValue.append("}");
                    if (this.braceCount != 0 || !this.isReadingValue) break;
                    this.isReadingValue = false;
                    this.resultHash.put(String.valueOf(fieldCounter++), this.currentValue.toString());
                    break;
                }
                case '[': {
                    ++this.braceCount;
                    if (!this.isReadingValue) {
                        this.isReadingValue = true;
                        this.currentField = new StringBuilder("[");
                        break;
                    }
                    this.currentValue.append("[");
                    break;
                }
                case ']': {
                    --this.braceCount;
                    this.currentField.append("]");
                    break;
                }
                case '\"': {
                    if (this.isReadingValue) {
                        if (this.escapeOn) {
                            this.currentValue.append('\"');
                        } else if (this.braceCount == 0) {
                            this.isReadingValue = false;
                            this.resultHash.put(String.valueOf(fieldCounter++), this.currentValue.toString());
                        } else {
                            this.currentValue.append('\"');
                        }
                    } else {
                        this.isReadingValue = true;
                        this.currentValue = new StringBuilder();
                    }
                    this.escapeOn = false;
                    break;
                }
                case '\\': {
                    this.escapeOn = !this.escapeOn;
                    break;
                }
                default: {
                    this.escapeOn = false;
                    if (!this.isReadingValue) break;
                    this.currentValue.append(this.inputString.charAt(i));
                }
            }
            ++i;
        }
        return this.resultHash;
    }
}

