/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JPanel;
import main.DataContainer;
import main.Player;

public class DrawingPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -713337227826917330L;
    public boolean isRunning = true;
    private BufferedImage buffImg;
    private Graphics2D buffPane;
    private Hashtable loadedImages;
    private DataContainer dataObj;

    public DrawingPanel(DataContainer data) {
        this.dataObj = data;
        this.loadedImages = new Hashtable();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawGraphic();
        Graphics2D tempGraphics = (Graphics2D)g;
        tempGraphics.drawImage(this.buffImg, null, 0, 0);
    }

    private void drawGraphic() {
        int paneWidth = this.getWidth();
        int paneHeight = this.getHeight();
        this.buffImg = (BufferedImage)this.createImage(paneWidth, paneHeight);
        this.buffPane = this.buffImg.createGraphics();
        this.buffPane.setBackground(Color.LIGHT_GRAY);
        this.buffPane.clearRect(0, 0, paneWidth, paneHeight);
        if (this.dataObj.isLoggedIn.booleanValue()) {
            if (this.dataObj.room.roomId > 0) {
                this.drawBackground(String.valueOf(this.dataObj.room.roomId));
            }
            this.drawPlayer(this.dataObj.currentUser);
            if (this.dataObj.playerList != null) {
                Player[] playerArray = this.dataObj.playerList;
                int n = this.dataObj.playerList.length;
                int n2 = 0;
                while (n2 < n) {
                    Player otherPlayer = playerArray[n2];
                    this.drawPlayer(otherPlayer);
                    ++n2;
                }
            }
            this.drawGhost(this.dataObj.ghost);
        }
    }

    private float getRelFactor() {
        return this.getWidth() > this.getHeight() ? (float)this.getHeight() / (float)DataContainer.screenHeight : (float)this.getWidth() / (float)DataContainer.screenWidth;
    }

    private boolean loadImage(String imgName) {
        try {
            String fullResourcePath = "/res/" + imgName + ".png";
            URL tempURL = this.getClass().getResource(fullResourcePath);
            if (tempURL == null) {
                throw new Exception("Resource '" + fullResourcePath + "' not found");
            }
            Image tempImage = Toolkit.getDefaultToolkit().getImage(tempURL);
            this.loadedImages.put((Object)imgName, (Object)tempImage);
            return true;
        }
        catch (Exception ex) {
            System.out.println("Image Load Error: " + ex.getMessage());
            return false;
        }
    }

    public void drawGhost(Player ghost) {
        try {
            float relFactor = this.getRelFactor();
            int ghostRelXpos = (int)((float)ghost.xCoord * relFactor);
            int ghostRelYpos = (int)((float)ghost.yCoord * relFactor);
            int ghostWidth = (int)(50.0f * relFactor);
            int ghostHeight = (int)(100.0f * relFactor);
            this.drawPlayerComponent("ghost", ghostRelXpos, ghostRelYpos, ghostWidth, ghostHeight);
        }
        catch (Exception ex) {
            System.out.println("ghost error: " + ex.getMessage());
        }
    }

    public void drawPlayer(Player player) {
        if (player != null) {
            try {
                float relFactor = this.getRelFactor();
                int playerRelXpos = (int)((float)player.xCoord * relFactor);
                int playerRelYpos = (int)((float)player.yCoord * relFactor);
                int playerWidth = (int)((float)DataContainer.playerSpriteWidth * relFactor);
                int playerHeight = (int)((float)DataContainer.playerSpriteHeight * relFactor);
                this.drawPlayerComponent("face" + player.face, playerRelXpos, playerRelYpos, playerWidth, playerHeight);
                this.drawPlayerComponent("shirt" + player.shirt, playerRelXpos, playerRelYpos, playerWidth, playerHeight);
                this.drawPlayerComponent("nose" + player.nose, playerRelXpos, playerRelYpos, playerWidth, playerHeight);
                this.drawPlayerComponent("hair" + player.hair, playerRelXpos, playerRelYpos, playerWidth, playerHeight);
                this.drawPlayerComponent("mouth" + player.mouth, playerRelXpos, playerRelYpos, playerWidth, playerHeight);
                this.drawPlayerComponent("eyes" + player.eyes, playerRelXpos, playerRelYpos, playerWidth, playerHeight);
            }
            catch (Exception ex) {
                System.out.println("player draw error: " + ex.getMessage());
            }
        }
    }

    private void drawPlayerComponent(String compName, int xPos, int yPos, int width, int height) {
        boolean imageLoaded = true;
        if (!this.loadedImages.containsKey((Object)compName)) {
            imageLoaded = this.loadImage(compName);
        }
        if (imageLoaded) {
            this.buffPane.drawImage((Image)this.loadedImages.get((Object)compName), xPos, yPos, width, height, null);
        }
    }

    private void drawBackground(String roomId) {
        boolean imageLoaded = true;
        if (!this.loadedImages.containsKey((Object)("room" + roomId))) {
            imageLoaded = this.loadImage("room" + roomId);
        }
        if (imageLoaded) {
            float relFactor = this.getRelFactor();
            int width = (int)((float)DataContainer.screenWidth * relFactor);
            int height = (int)((float)DataContainer.screenHeight * relFactor);
            this.buffPane.drawImage((Image)this.loadedImages.get((Object)("room" + roomId)), 0, 0, width, height, null);
        }
    }

    @Override
    public void run() {
        while (this.isRunning) {
            this.dataObj.currentUser.xCoord = this.dataObj.userTargetPoint.x >= this.dataObj.currentUser.xCoord + this.dataObj.userSpeed ? (this.dataObj.currentUser.xCoord += this.dataObj.userSpeed) : (this.dataObj.userTargetPoint.x <= this.dataObj.currentUser.xCoord - this.dataObj.userSpeed ? (this.dataObj.currentUser.xCoord -= this.dataObj.userSpeed) : this.dataObj.userTargetPoint.x);
            this.dataObj.currentUser.yCoord = this.dataObj.userTargetPoint.y >= this.dataObj.currentUser.yCoord + this.dataObj.userSpeed ? (this.dataObj.currentUser.yCoord += this.dataObj.userSpeed) : (this.dataObj.userTargetPoint.y <= this.dataObj.currentUser.yCoord - this.dataObj.userSpeed ? (this.dataObj.currentUser.yCoord -= this.dataObj.userSpeed) : this.dataObj.userTargetPoint.y);
            if (this.dataObj.currentUser.xCoord > DataContainer.screenWidth - DataContainer.playerSpriteWidth - 10 && this.dataObj.room.exitEast > 0) {
                this.dataObj.currentUser.room = this.dataObj.room.exitEast;
                this.dataObj.currentUser.xCoord = 10;
                this.dataObj.userTargetPoint.x = 10;
                this.dataObj.room = this.dataObj.getRoomData(String.valueOf(this.dataObj.room.exitEast));
            }
            if (this.dataObj.currentUser.xCoord < 10 && this.dataObj.room.exitWest > 0) {
                this.dataObj.currentUser.room = this.dataObj.room.exitWest;
                this.dataObj.currentUser.xCoord = DataContainer.screenWidth - DataContainer.playerSpriteWidth - 10;
                this.dataObj.userTargetPoint.x = DataContainer.screenWidth - DataContainer.playerSpriteWidth - 10;
                this.dataObj.room = this.dataObj.getRoomData(String.valueOf(this.dataObj.room.exitWest));
            }
            if (this.dataObj.currentUser.yCoord < 10 && this.dataObj.room.exitNorth > 0) {
                this.dataObj.currentUser.room = this.dataObj.room.exitNorth;
                this.dataObj.currentUser.yCoord = DataContainer.screenHeight - DataContainer.playerSpriteHeight - 10;
                this.dataObj.userTargetPoint.y = DataContainer.screenHeight - DataContainer.playerSpriteHeight - 10;
                this.dataObj.room = this.dataObj.getRoomData(String.valueOf(this.dataObj.room.exitNorth));
            }
            if (this.dataObj.currentUser.yCoord > DataContainer.screenHeight - DataContainer.playerSpriteHeight - 10 && this.dataObj.room.exitSouth > 0) {
                this.dataObj.currentUser.room = this.dataObj.room.exitSouth;
                this.dataObj.currentUser.yCoord = 10;
                this.dataObj.userTargetPoint.y = 10;
                this.dataObj.room = this.dataObj.getRoomData(String.valueOf(this.dataObj.room.exitSouth));
            }
            try {
                this.repaint();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

