/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import main.DataConnector;
import main.JSONReader;
import main.MainForm;
import main.Player;
import main.Room;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContainer
extends TimerTask {
    public static int screenWidth = 800;
    public static int screenHeight = 800;
    public static int playerSpriteWidth = 50;
    public static int playerSpriteHeight = 100;
    public Player currentUser;
    public Player[] playerList;
    public Player ghost = new Player();
    public Room room = new Room();
    public Hashtable<String, Player> playerData = new Hashtable();
    public Point userTargetPoint = new Point(0, 0);
    public int userSpeed = 10;
    public DataConnector serverConnection = new DataConnector("http://localhost/PlayHP/");
    public Boolean isLoggedIn = false;
    private MainForm chatDisplay = null;
    private long latestChatTimestamp = 0L;
    private long latestChatServerTimestamp = 0L;
    private Boolean showTime = false;

    public DataContainer() {
        this.readParameterFile();
        this.currentUser = new Player();
        this.latestChatServerTimestamp = this.latestChatTimestamp = new Date().getTime();
    }

    public void setChatDisplay(MainForm tfChatDisplay) {
        this.chatDisplay = tfChatDisplay;
    }

    private void readParameterFile() {
        try {
            FileInputStream filestream = new FileInputStream("testClientParam.ini");
            DataInputStream inStream = new DataInputStream(filestream);
            BufferedReader templateReader = new BufferedReader(new InputStreamReader(inStream));
            String inputLine = null;
            Hashtable<String, String> paramTable = new Hashtable<String, String>();
            while ((inputLine = templateReader.readLine()) != null) {
                String[] paramArray = inputLine.split("=", 2);
                if (paramArray.length != 2) continue;
                paramTable.put(paramArray[0].toLowerCase().trim(), paramArray[1].trim());
            }
            if (!paramTable.containsKey("baseurl")) {
                throw new Exception("'baseurl' parameter not found.");
            }
            this.serverConnection.setBaseUrl((String)paramTable.get("baseurl"));
            System.out.println("connecting to " + (String)paramTable.get("baseurl"));
            if (paramTable.containsKey("showtime")) {
                System.out.println("timeparam : \"" + (String)paramTable.get("showtime") + "\"");
                if (((String)paramTable.get("showtime")).compareTo("1") == 0) {
                    this.showTime = true;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " Trying to connect to 'localhost'.");
        }
    }

    @Override
    public void run() {
        if (this.isLoggedIn.booleanValue() && this.currentUser.room > 0) {
            this.updateServer();
            if (this.chatDisplay != null) {
                this.updateChat();
            }
        }
    }

    private void updateServer() {
        String coordXString = "0";
        String coordYString = "0";
        String roomString = "0";
        long startTime = new Date().getTime();
        try {
            JSONReader jReader;
            Hashtable<String, String> rootData;
            coordXString = Integer.toString(this.currentUser.xCoord);
            coordYString = Integer.toString(this.currentUser.yCoord);
            String newData = "";
            if (this.currentUser.room > 0) {
                roomString = Integer.toString(this.currentUser.room);
                newData = "userdata[xpos]=" + URLEncoder.encode(coordXString, "UTF-8") + "&userdata[ypos]=" + URLEncoder.encode(coordYString, "UTF-8") + "&userdata[room]=" + URLEncoder.encode(roomString, "UTF-8");
            } else {
                newData = "userdata[xpos]=" + URLEncoder.encode(coordXString, "UTF-8") + "&userdata[ypos]=" + URLEncoder.encode(coordYString, "UTF-8");
            }
            String httpResult = this.serverConnection.sendData("setdata.php", newData);
            if (this.showTime.booleanValue()) {
                System.out.print("netTime: " + (new Date().getTime() - startTime));
            }
            if ((rootData = (jReader = new JSONReader(httpResult)).readInput()).containsKey("prio_userdata")) {
                Hashtable<String, String> debugInfo;
                Enumeration<String> allDebugInfo;
                jReader.setInputString(rootData.get("prio_userdata"));
                Hashtable<String, String> userData = jReader.readInput();
                Enumeration<String> allUsers = userData.elements();
                if (userData.size() > 1) {
                    Player[] newUserList = new Player[userData.size() - 1];
                    int arrayCount = 0;
                    while (allUsers.hasMoreElements()) {
                        String user = allUsers.nextElement();
                        jReader.setInputString(user);
                        Hashtable<String, String> userInfo = jReader.readInput();
                        if (!userInfo.containsKey("uid") || userInfo.get("uid").equals(String.valueOf(this.currentUser.id))) continue;
                        try {
                            String tempUidString = userInfo.get("uid");
                            String tempXpos = userInfo.get("xpos");
                            String tempYpos = userInfo.get("ypos");
                            if (this.playerData.containsKey(tempUidString)) {
                                newUserList[arrayCount] = this.playerData.get(tempUidString);
                            } else {
                                Player tempPlayer = this.getPlayerData(Integer.parseInt(tempUidString));
                                this.playerData.put(tempUidString, tempPlayer);
                                newUserList[arrayCount] = tempPlayer;
                            }
                            newUserList[arrayCount].xCoord = Integer.parseInt(tempXpos);
                            newUserList[arrayCount].yCoord = Integer.parseInt(tempYpos);
                        }
                        catch (Exception ex) {
                            System.out.println("Error: " + ex.getMessage());
                        }
                    }
                    this.playerList = newUserList;
                } else {
                    this.playerList = new Player[0];
                }
                Hashtable<String, String> ghostInfo = this.getFirstItemFromKey(httpResult, "prio_ghost");
                if (ghostInfo.size() > 0) {
                    this.ghost.xCoord = Integer.parseInt(ghostInfo.get("xpos"));
                    this.ghost.yCoord = Integer.parseInt(ghostInfo.get("ypos"));
                } else {
                    this.ghost.xCoord = -200;
                }
                if (this.showTime.booleanValue() && (allDebugInfo = (debugInfo = this.getFirstItemFromKey(httpResult, "debuginfo")).elements()).hasMoreElements()) {
                    String info = allDebugInfo.nextElement();
                    System.out.print(",serverTime: " + info);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error : " + ex.getMessage());
        }
        if (this.showTime.booleanValue()) {
            System.out.println(",updateTime: " + (new Date().getTime() - startTime));
        }
    }

    private void updateChat() {
        try {
            long tempTimeStamp = new Date().getTime();
            if (tempTimeStamp - this.latestChatTimestamp > 500L) {
                String messageCond = "tstamp>" + String.valueOf(this.latestChatServerTimestamp) + " AND position=" + this.currentUser.room;
                String newData = "groups[messages]=" + URLEncoder.encode(messageCond, "UTF-8");
                String httpResult = this.serverConnection.sendData("getdata.php", newData);
                JSONReader jReader = new JSONReader(httpResult);
                Hashtable<String, String> rootData = jReader.readInput();
                if (rootData.containsKey("messages")) {
                    jReader.setInputString(rootData.get("messages"));
                    Hashtable<String, String> messageData = jReader.readInput();
                    Enumeration<String> allMessages = messageData.elements();
                    while (allMessages.hasMoreElements()) {
                        String message = allMessages.nextElement();
                        jReader.setInputString(message);
                        Hashtable<String, String> messageInfo = jReader.readInput();
                        if (!messageInfo.containsKey("message") || !messageInfo.containsKey("tstamp")) continue;
                        long serverTstamp = Long.parseLong(messageInfo.get("tstamp"));
                        if (this.latestChatServerTimestamp < serverTstamp) {
                            this.latestChatServerTimestamp = serverTstamp;
                        }
                        String senderName = "unknown";
                        if (messageInfo.containsKey("sender")) {
                            int senderId = Integer.parseInt(messageInfo.get("sender"));
                            if (senderId == this.currentUser.id) {
                                senderName = this.currentUser.name;
                            } else {
                                Player[] playerArray = this.playerList;
                                int n = this.playerList.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Player tempPlayer = playerArray[n2];
                                    if (tempPlayer.id == senderId) {
                                        senderName = tempPlayer.name;
                                    }
                                    ++n2;
                                }
                            }
                        }
                        this.chatDisplay.writeText("<b>" + senderName + "</b>:" + messageInfo.get("message"));
                    }
                }
                this.latestChatTimestamp = tempTimeStamp;
            }
        }
        catch (Exception ex) {
            System.out.println("chat error: " + ex.getMessage());
        }
    }

    private Player getPlayerData(int playerId) {
        String playerIdString = String.valueOf(playerId);
        Player resultPlayer = new Player();
        resultPlayer.id = playerId;
        String newData = "";
        try {
            newData = "groups[userlooks]=person%3d" + URLEncoder.encode(playerIdString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("encoding error: " + ex.getMessage());
        }
        String httpResult = this.serverConnection.sendData("getdata.php", newData);
        Hashtable<String, String> userInfo = this.getFirstItemFromKey(httpResult, "userlooks");
        try {
            resultPlayer.eyes = Integer.parseInt(userInfo.get("eyes"));
            resultPlayer.face = Integer.parseInt(userInfo.get("face"));
            resultPlayer.hair = Integer.parseInt(userInfo.get("hair"));
            resultPlayer.nose = Integer.parseInt(userInfo.get("nose"));
            resultPlayer.mouth = Integer.parseInt(userInfo.get("mouth"));
            resultPlayer.shirt = Integer.parseInt(userInfo.get("shirt"));
        }
        catch (Exception ex) {
            System.out.println("user data error: " + ex.getMessage());
        }
        try {
            newData = "groups[userdata]=uid%3d" + URLEncoder.encode(playerIdString, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("data encoding error: " + ex.getMessage());
        }
        httpResult = this.serverConnection.sendData("getdata.php", newData);
        userInfo = this.getFirstItemFromKey(httpResult, "userdata");
        try {
            resultPlayer.name = userInfo.get("username");
        }
        catch (Exception ex) {
            System.out.println("data error : " + ex.getMessage());
        }
        return resultPlayer;
    }

    public Room getRoomData() {
        Room resultRoom = new Room();
        String tempRoomIdString = "";
        String userId = String.valueOf(this.currentUser.id);
        String newData = "";
        try {
            newData = "groups[userdata]=uid%3d" + URLEncoder.encode(userId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Error: " + e.getMessage());
        }
        String httpResult = this.serverConnection.sendData("getdata.php", newData);
        Hashtable<String, String> userInfo = this.getFirstItemFromKey(httpResult, "userdata");
        if (userInfo.containsKey("room")) {
            tempRoomIdString = userInfo.get("room");
            resultRoom = this.getRoomData(tempRoomIdString);
        }
        return resultRoom;
    }

    public Room getRoomData(String roomIdString) {
        Room resultRoom = new Room();
        String newData = "";
        try {
            newData = "groups[room]=id%3d" + URLEncoder.encode(roomIdString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Error: " + e.getMessage());
        }
        String httpResult = this.serverConnection.sendData("getdata.php", newData);
        Hashtable<String, String> userInfo = this.getFirstItemFromKey(httpResult, "room");
        if (userInfo.size() > 4) {
            try {
                resultRoom.roomName = userInfo.get("roomname");
                resultRoom.exitNorth = Integer.parseInt(userInfo.get("exitnorth"));
                resultRoom.exitEast = Integer.parseInt(userInfo.get("exiteast"));
                resultRoom.exitSouth = Integer.parseInt(userInfo.get("exitsouth"));
                resultRoom.exitWest = Integer.parseInt(userInfo.get("exitwest"));
                resultRoom.roomId = Integer.parseInt(roomIdString);
            }
            catch (Exception ex) {
                System.out.println("room data error:" + ex.getMessage());
            }
        }
        return resultRoom;
    }

    private Hashtable<String, String> getFirstItemFromKey(String jsonString, String lookupKey) {
        JSONReader jReader = new JSONReader(jsonString);
        Hashtable<String, String> rootData = jReader.readInput();
        try {
            if (rootData.containsKey(lookupKey)) {
                jReader.setInputString(rootData.get(lookupKey));
                Hashtable<String, String> keyData = jReader.readInput();
                Enumeration<String> keyDataEnum = keyData.elements();
                if (keyDataEnum.hasMoreElements()) {
                    jReader.setInputString(keyDataEnum.nextElement());
                    Hashtable<String, String> keyInfo = jReader.readInput();
                    return keyInfo;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("JSON error : " + ex.getMessage());
        }
        return new Hashtable<String, String>();
    }

    public Boolean loginPlayer(String username, String password) {
        String loginParameter = "";
        String currentTimeStamp = String.valueOf(new Date().getTime());
        String stampAndPwd = String.valueOf(currentTimeStamp) + password;
        byte[] md5Bytes = new byte[]{};
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(stampAndPwd.getBytes());
            md5Bytes = md5.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("md5 error : " + ex.getMessage());
        }
        StringBuffer tempMagicVal = new StringBuffer();
        int i = 0;
        while (i < md5Bytes.length) {
            String hexString = Integer.toHexString(0xFF & md5Bytes[i]);
            while (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            tempMagicVal.append(hexString);
            ++i;
        }
        String magicVal = tempMagicVal.toString();
        try {
            loginParameter = "username=" + URLEncoder.encode(username, "UTF-8") + "&pwdval=" + URLEncoder.encode(magicVal, "UTF-8") + "&loginTime=" + URLEncoder.encode(currentTimeStamp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("encoding error : " + ex.getMessage());
        }
        String httpResult = this.serverConnection.sendData("login.php", loginParameter);
        JSONReader jReader = new JSONReader(httpResult);
        Hashtable<String, String> resultHash = jReader.readInput();
        if (resultHash.containsKey("error")) {
            System.out.println(resultHash.get("error"));
            JOptionPane.showMessageDialog(null, resultHash.get("error"), "Login Error", 0);
            return false;
        }
        if (resultHash.containsKey("login")) {
            if (resultHash.get("login").equals("success")) {
                int playerId = 0;
                if (resultHash.containsKey("userid")) {
                    try {
                        playerId = Integer.parseInt(resultHash.get("userid"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (playerId > 0) {
                        this.currentUser = this.getPlayerData(playerId);
                        this.room = this.getRoomData();
                        this.currentUser.room = this.room.roomId;
                    }
                }
                this.isLoggedIn = true;
                return true;
            }
            JOptionPane.showMessageDialog(null, "undefined error", "Login Error", 0);
            System.out.println("Login Error");
            return false;
        }
        return false;
    }

    public Boolean logoutPlayer() {
        if (this.currentUser.id > 0) {
            String logoutParameter = "userId=" + String.valueOf(this.currentUser.id);
            String httpResult = this.serverConnection.sendData("logout.php", logoutParameter);
            JSONReader jReader = new JSONReader(httpResult);
            Hashtable<String, String> resultHash = jReader.readInput();
            if (resultHash.containsKey("error")) {
                System.out.println(resultHash.get("error"));
                JOptionPane.showMessageDialog(null, resultHash.get("error"), "Logout Error", 0);
                return false;
            }
            if (resultHash.containsKey("login")) {
                if (resultHash.get("logout").equals("success")) {
                    this.isLoggedIn = false;
                    return true;
                }
                JOptionPane.showMessageDialog(null, "undefined error", "Logout Error", 0);
                return false;
            }
            return false;
        }
        return false;
    }
}

