<?php
include_once 'init.php.inc';

include_once 'checklogin.php.inc';
include_once 'setprioinfo.php.inc';
include_once 'setchangeinfo.php.inc';

/*
 * MAIN
 */

if (isset( $GLOBALS['paramArray']) && is_array( $GLOBALS['paramArray'] ) ){
	
	foreach($GLOBALS['setArray'] AS $groupname => $groupsettings){
	
		if (isset($GLOBALS['paramArray'][$groupname]   )){

			$oldValues = array();
			
			// read the current db values for this group/table if it is an 'update' table
			if ($groupsettings['type']=='update'){
				$fieldlist = '';
				foreach ($groupsettings['updateFields'] AS $fieldname => $fieldvalue){
					$fieldlist .= $fieldname . ',';
				}
				$fieldlist = rtrim($fieldlist , ',');
				
				$oldValueArray = queryDB( constTABLEPREFIX .  $groupname, $fieldlist, $groupsettings['where']);
				
				if(  count($oldValueArray) > 0)
					$oldValues = $oldValueArray[0];
			}
			
			
			$GLOBALS['newvalArray'][$groupname] = array();
			$fieldlist = '';
			
			foreach ($groupsettings['updateFields'] AS $fieldname => $fieldsetting ){

				if (isset($GLOBALS['paramArray'][$groupname][$fieldname]   )){
				
					$testFunctionName = 'set_' . $groupname . '_' . $fieldname ; 
					
					$changeAllowed = FALSE;
					
					if (function_exists($testFunctionName)){
						$changeAllowed = ($testFunctionName($GLOBALS['paramArray'][$groupname], $oldValues) === TRUE );
					}
					else {
						// always allow changes if no testfunction is given
						$changeAllowed = TRUE;
					}

					if ($changeAllowed){
						$fieldlist .= $fieldname . '="' . $GLOBALS['paramArray'][$groupname][$fieldname] . '",';
					}
					else {
						// for groups with mref values an update is only allowed if all fields are valid
						if ($groupsettings['type'] != 'update'){
							$fieldlist = '';
							break;
						}
					}
				}
			}
			
			$fieldlist = rtrim($fieldlist, ',');

			if ($fieldlist != ''){
				$tempArray = array(
					'type' => $GLOBALS['setArray'][$groupname]['type'] ,
					'fieldSetting' => $fieldlist,
					'where' => $GLOBALS['setArray'][$groupname]['where']
				);

				$GLOBALS['newvalArray'][$groupname][] = $tempArray;
			}
		}	
		
	}
} 



// gather info for automatical data update
include_once 'update.php.inc';


foreach ($GLOBALS['newvalArray'] AS $groupname => $valuelist){
	updateDB( constTABLEPREFIX . $groupname, $valuelist);
}

// read prio data (after the update)
include_once 'getprio.php.inc';

if (constSHOWDEBUGINFO) $dataarray['debuginfo'][0] = array('time' => (getMillisecs() - $starttime) );

/* generate output */
echo renderOutput($GLOBALS['dataarray']);


/**
 * SUBFUNCTIONS
 */

function updateDB($tableName, $valuelist){
	
	foreach ($valuelist AS $settings){
		
		$whereString =    (! empty($settings['where']) ? ' WHERE ' . $settings['where'] : '') ; 
		
		$query = $settings['type'] . ' ' . $tableName . ' SET ' . utf8_decode( $settings['fieldSetting'] ) . $whereString;
		
		//echo $query;
		mysql_query($query);
	}
}


?>