/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TemplateEvaluator {
    public String inputFileName = "";
    public String outputFileName = "";
    public Hashtable<String, Vector<Hashtable<String, String>>> sectionData = null;
    public Hashtable<String, String> replacementData = null;

    public static void main(String[] args) {
        Hashtable<String, String> replacementData = new Hashtable<String, String>();
        replacementData.put("###ARRAY_SETARRAY_DEFINITION###", "Dies ist der Platzhalter f\u00fcr das Array");
        replacementData.put("###GLOBAL_VARIABLES###", "$user_a,$user_b");
        Hashtable<String, Vector<Hashtable<String, String>>> sectionData = new Hashtable<String, Vector<Hashtable<String, String>>>();
        Vector dataVector = new Vector();
        Hashtable<String, String> data1 = new Hashtable<String, String>();
        data1.put("###GROUPNAME###", "Avengers");
        data1.put("###FIELDNAME###", "Hulk");
        data1.put("###USER_INPUT_CHANGE###", "bla bla function(){ pp pp pp }");
        dataVector.add(data1);
        Hashtable<String, String> data2 = new Hashtable<String, String>();
        data2.put("###GROUPNAME###", "Fantastic Four");
        data2.put("###FIELDNAME###", "Sue");
        data2.put("###USER_INPUT_CHANGE###", "egal");
        dataVector.add(data2);
        Hashtable<String, String> data3 = new Hashtable<String, String>();
        data3.put("###GROUPNAME###", "Avengers");
        data3.put("###FIELDNAME###", "IronMan");
        data3.put("###USER_INPUT_CHANGE###", "blub blub function(){ Inhalt }");
        dataVector.add(data3);
        sectionData.put("###SECTION_FUNCTION_TESTSET_BEGIN###", dataVector);
        String filePath = System.getProperty("user.dir");
        System.out.println(filePath);
        TemplateEvaluator testTE = new TemplateEvaluator("/templates/setchangeinfo.php.inc.tmpl", "default/testout.txt", replacementData, sectionData);
        try {
            testTE.evaluateTemplate();
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public TemplateEvaluator() {
    }

    public TemplateEvaluator(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public TemplateEvaluator(String inputFileName, String outputFileName) {
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
    }

    public TemplateEvaluator(String inputFileName, String outputFileName, Hashtable<String, String> replacementData) {
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
        this.replacementData = replacementData;
    }

    public TemplateEvaluator(String inputFileName, String outputFileName, Hashtable<String, String> replacementData, Hashtable<String, Vector<Hashtable<String, String>>> sectionData) {
        this.inputFileName = inputFileName;
        this.outputFileName = outputFileName;
        this.replacementData = replacementData;
        this.sectionData = sectionData;
    }

    public void evaluateTemplate() throws IOException {
        StringBuilder outputData = new StringBuilder();
        InputStream templateInput = this.getClass().getResourceAsStream(this.inputFileName);
        if (templateInput == null) {
            throw new IOException("File '" + this.inputFileName + "' not found");
        }
        BufferedReader templateReader = new BufferedReader(new InputStreamReader(templateInput));
        String inputLine = null;
        while ((inputLine = templateReader.readLine()) != null) {
            if (this.sectionData.containsKey(inputLine.trim())) {
                String sectionStartTag = inputLine.trim();
                String sectionEndTag = String.valueOf(inputLine.trim().substring(0, inputLine.trim().length() - 9)) + "_END###";
                String tempLine = null;
                StringBuilder sectionBlock = new StringBuilder();
                do {
                    if ((tempLine = templateReader.readLine()) == null) continue;
                    if (tempLine.trim().equals(sectionEndTag)) {
                        tempLine = null;
                        continue;
                    }
                    sectionBlock.append(String.valueOf(this.substituteReplacementData(tempLine)) + "\r\n");
                } while (tempLine != null);
                outputData.append((CharSequence)this.substituteSectionData(sectionBlock, this.sectionData.get(sectionStartTag)));
                continue;
            }
            inputLine = String.valueOf(this.substituteReplacementData(inputLine)) + "\r\n";
            outputData.append(inputLine);
        }
        if (this.outputFileName.length() == 0) {
            System.out.println("Error: no output filename given for " + this.inputFileName);
            return;
        }
        FileOutputStream tempStream = new FileOutputStream(this.outputFileName);
        DataOutputStream outStream = new DataOutputStream(tempStream);
        TemplateEvaluator.writeStringToStream(outStream, outputData.toString());
    }

    private static void writeStringToStream(OutputStream out, String text) {
        try {
            int i = 0;
            while (i < text.length()) {
                out.write((byte)text.charAt(i));
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Output Error:");
            System.out.println(e.getMessage());
        }
    }

    private String substituteReplacementData(String input) {
        Enumeration<String> replaceKeys = this.replacementData.keys();
        while (replaceKeys.hasMoreElements()) {
            String hashKey = replaceKeys.nextElement();
            input = input.replace(hashKey, this.replacementData.get(hashKey));
        }
        return input;
    }

    private StringBuilder substituteSectionData(StringBuilder input, Vector<Hashtable<String, String>> currentSectionData) {
        StringBuilder output = new StringBuilder();
        for (Hashtable<String, String> singleSectionData : currentSectionData) {
            Enumeration<String> replaceKeys = singleSectionData.keys();
            String tempInput = input.toString();
            while (replaceKeys.hasMoreElements()) {
                String hashKey = replaceKeys.nextElement();
                tempInput = tempInput.replace(hashKey, singleSectionData.get(hashKey));
            }
            output.append(tempInput);
        }
        return output;
    }

    public void setSectionData(Hashtable<String, Vector<Hashtable<String, String>>> sectionData) {
        this.sectionData = sectionData;
    }

    public void setReplacementData(Hashtable<String, String> replacementData) {
        this.replacementData = replacementData;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public Hashtable<String, Vector<Hashtable<String, String>>> getSectionData() {
        return this.sectionData;
    }

    public Hashtable<String, String> getReplacementData() {
        return this.replacementData;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }
}

